#include "main.h"
#include "LCD1602.h"
TIM_HandleTypeDef htim1;
void SystemClock_Config(void);
static void MX_GPIO_Init(void);
static void MX_TIM1_Init(void);
int main(void)
{
  HAL_Init();
  SystemClock_Config();
  MX_GPIO_Init();
  MX_TIM1_Init();
  uint8_t  B_B ;
  HAL_TIM_Base_Start(&htim1);

  lcd_init ();
  lcd_clear();

  lcd_put_cur(0, 0);
  lcd_send_string("   Panda Kit    ");
  lcd_put_cur(1, 0);
  lcd_send_string("SW -- is Preesed");

  while (1)
  {
	    B_B=0;
	  	HAL_GPIO_WritePin(DO_Row1_GPIO_Port, DO_Row1_Pin, 0);
	  	HAL_GPIO_WritePin(DO_Row2_GPIO_Port, DO_Row2_Pin, 1);
	  	HAL_GPIO_WritePin(DO_Row3_GPIO_Port, DO_Row3_Pin, 1);
	  	HAL_GPIO_WritePin(DO_Row4_GPIO_Port, DO_Row4_Pin, 1);
	  	if (HAL_GPIO_ReadPin(DI_Col1_GPIO_Port, DI_Col1_Pin) == 0 )B_B=1;
	  	else if(HAL_GPIO_ReadPin(DI_Col2_GPIO_Port, DI_Col2_Pin) == 0)B_B=2;
	  	else if(HAL_GPIO_ReadPin(DI_Col3_GPIO_Port, DI_Col3_Pin) == 0)B_B=3;
	  	else if(HAL_GPIO_ReadPin(DI_Col4_GPIO_Port, DI_Col4_Pin) == 0)B_B=4;
	  	HAL_GPIO_WritePin(DO_Row1_GPIO_Port, DO_Row1_Pin, 1);
	  	if (B_B!=0) goto Exit_Scan;
	  	//-----
	  	HAL_GPIO_WritePin(DO_Row2_GPIO_Port, DO_Row2_Pin, 0);
	  	HAL_GPIO_WritePin(DO_Row1_GPIO_Port, DO_Row1_Pin, 1);
	  	HAL_GPIO_WritePin(DO_Row3_GPIO_Port, DO_Row3_Pin, 1);
	  	HAL_GPIO_WritePin(DO_Row4_GPIO_Port, DO_Row4_Pin, 1);
	  	if (HAL_GPIO_ReadPin(DI_Col1_GPIO_Port, DI_Col1_Pin) == 0 )B_B=5;
	  	else if(HAL_GPIO_ReadPin(DI_Col2_GPIO_Port, DI_Col2_Pin) == 0)B_B=6;
	  	else if(HAL_GPIO_ReadPin(DI_Col3_GPIO_Port, DI_Col3_Pin) == 0)B_B=7;
	  	else if(HAL_GPIO_ReadPin(DI_Col4_GPIO_Port, DI_Col4_Pin) == 0)B_B=8;
	  	HAL_GPIO_WritePin(DO_Row2_GPIO_Port, DO_Row2_Pin, 1);
	  	if (B_B!=0) goto Exit_Scan;
	  	//-----
	  	HAL_GPIO_WritePin(DO_Row3_GPIO_Port, DO_Row3_Pin, 0);
	  	HAL_GPIO_WritePin(DO_Row1_GPIO_Port, DO_Row1_Pin, 1);
	  	HAL_GPIO_WritePin(DO_Row2_GPIO_Port, DO_Row2_Pin, 1);
	  	HAL_GPIO_WritePin(DO_Row4_GPIO_Port, DO_Row4_Pin, 1);
	  	if (HAL_GPIO_ReadPin(DI_Col1_GPIO_Port, DI_Col1_Pin) == 0 )B_B=9;
	  	else if(HAL_GPIO_ReadPin(DI_Col2_GPIO_Port, DI_Col2_Pin) == 0)B_B=10;
	  	else if(HAL_GPIO_ReadPin(DI_Col3_GPIO_Port, DI_Col3_Pin) == 0)B_B=11;
	  	else if(HAL_GPIO_ReadPin(DI_Col4_GPIO_Port, DI_Col4_Pin) == 0)B_B=12;
	  	HAL_GPIO_WritePin(DO_Row3_GPIO_Port, DO_Row3_Pin, 1);
	  	if (B_B!=0) goto Exit_Scan;
	  	//-----
	  	HAL_GPIO_WritePin(DO_Row4_GPIO_Port, DO_Row4_Pin, 0);
	  	HAL_GPIO_WritePin(DO_Row1_GPIO_Port, DO_Row1_Pin, 1);
	  	HAL_GPIO_WritePin(DO_Row2_GPIO_Port, DO_Row2_Pin, 1);
	  	HAL_GPIO_WritePin(DO_Row3_GPIO_Port, DO_Row3_Pin, 1);
	  	if (HAL_GPIO_ReadPin(DI_Col1_GPIO_Port, DI_Col1_Pin) == 0 )B_B=13;
	  	else if(HAL_GPIO_ReadPin(DI_Col2_GPIO_Port, DI_Col2_Pin) == 0)B_B=14;
	  	else if(HAL_GPIO_ReadPin(DI_Col3_GPIO_Port, DI_Col3_Pin) == 0)B_B=15;
	  	else if(HAL_GPIO_ReadPin(DI_Col4_GPIO_Port, DI_Col4_Pin) == 0)B_B=16;
	  	HAL_GPIO_WritePin(DO_Row4_GPIO_Port, DO_Row4_Pin, 1);
Exit_Scan:
		if(B_B==1)
		{
			lcd_put_cur(1, 3);
			lcd_send_string("01");
			HAL_Delay(150);
		}
		else if(B_B==2)
		{
			lcd_put_cur(1, 3);
			lcd_send_string("02");
			HAL_Delay(150);
		}
		else if(B_B==3)
		{
			lcd_put_cur(1, 3);
			lcd_send_string("03");
			HAL_Delay(150);
		}
		else if(B_B==4)
		{
			lcd_put_cur(1, 3);
			lcd_send_string("04");
			HAL_Delay(150);
		}
		else if(B_B==5)
		{
			lcd_put_cur(1, 3);
			lcd_send_string("05");
			HAL_Delay(150);
		}
		else if(B_B==6)
		{
			lcd_put_cur(1, 3);
			lcd_send_string("06");
			HAL_Delay(150);
		}
		else if(B_B==7)
		{
			lcd_put_cur(1, 3);
			lcd_send_string("07");
			HAL_Delay(150);
		}
		else if(B_B==8)
		{
			lcd_put_cur(1, 3);
			lcd_send_string("08");
			HAL_Delay(150);
		}
		else if(B_B==9)
		{
			lcd_put_cur(1, 3);
			lcd_send_string("09");
			HAL_Delay(150);
		}
		else if(B_B==10)
		{
			lcd_put_cur(1, 3);
			lcd_send_string("10");
			HAL_Delay(150);
		}
		else if(B_B==11)
		{
			lcd_put_cur(1, 3);
			lcd_send_string("11");
			HAL_Delay(150);
		}
		else if(B_B==12)
		{
			lcd_put_cur(1, 3);
			lcd_send_string("12");
			HAL_Delay(150);
		}
		else if(B_B==13)
		{
			lcd_put_cur(1, 3);
			lcd_send_string("13");
			HAL_Delay(150);
		}
		else if(B_B==14)
		{
			lcd_put_cur(1, 3);
			lcd_send_string("14");
			HAL_Delay(150);
		}
		else if(B_B==15)
		{
			lcd_put_cur(1, 3);
			lcd_send_string("15");
			HAL_Delay(150);
		}
		else if(B_B==16)
		{
			lcd_put_cur(1, 3);
			lcd_send_string("16");
			HAL_Delay(150);
		}
		else
		{
		lcd_put_cur(1, 3);
		lcd_send_string("--");
		}
  }
}
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Initializes the CPU, AHB and APB busses clocks
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSE;
  RCC_OscInitStruct.HSEState = RCC_HSE_ON;
  RCC_OscInitStruct.HSEPredivValue = RCC_HSE_PREDIV_DIV1;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSE;
  RCC_OscInitStruct.PLL.PLLMUL = RCC_PLL_MUL9;
  HAL_RCC_OscConfig(&RCC_OscInitStruct);
  /** Initializes the CPU, AHB and APB busses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV2;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;

  HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_2);
}
static void MX_TIM1_Init(void)
{
  TIM_ClockConfigTypeDef sClockSourceConfig = {0};
  TIM_MasterConfigTypeDef sMasterConfig = {0};

  htim1.Instance = TIM1;
  htim1.Init.Prescaler = 72-1;
  htim1.Init.CounterMode = TIM_COUNTERMODE_UP;
  htim1.Init.Period = 0xffff-1;
  htim1.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
  htim1.Init.RepetitionCounter = 0;
  htim1.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_DISABLE;
  HAL_TIM_Base_Init(&htim1);
  sClockSourceConfig.ClockSource = TIM_CLOCKSOURCE_INTERNAL;
  HAL_TIM_ConfigClockSource(&htim1, &sClockSourceConfig);
  sMasterConfig.MasterOutputTrigger = TIM_TRGO_RESET;
  sMasterConfig.MasterSlaveMode = TIM_MASTERSLAVEMODE_DISABLE;
  HAL_TIMEx_MasterConfigSynchronization(&htim1, &sMasterConfig);

}
static void MX_GPIO_Init(void)
{
  GPIO_InitTypeDef GPIO_InitStruct = {0};

  /* GPIO Ports Clock Enable */
  __HAL_RCC_GPIOD_CLK_ENABLE();
  __HAL_RCC_GPIOA_CLK_ENABLE();
  __HAL_RCC_GPIOB_CLK_ENABLE();

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(GPIOA, DO_Row1_Pin|DO_Row2_Pin|DO_Row3_Pin|DO_Row4_Pin
                          |GPIO_PIN_8|GPIO_PIN_11, GPIO_PIN_RESET);

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(GPIOB, GPIO_PIN_12|GPIO_PIN_13|GPIO_PIN_14|GPIO_PIN_15, GPIO_PIN_RESET);

  /*Configure GPIO pins : DO_Row1_Pin DO_Row2_Pin DO_Row3_Pin DO_Row4_Pin
                           PA8 PA11 */
  GPIO_InitStruct.Pin = DO_Row1_Pin|DO_Row2_Pin|DO_Row3_Pin|DO_Row4_Pin
                          |GPIO_PIN_8|GPIO_PIN_11;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /*Configure GPIO pins : DI_Col4_Pin DI_Col3_Pin DI_Col2_Pin DI_Col1_Pin */
  GPIO_InitStruct.Pin = DI_Col4_Pin|DI_Col3_Pin|DI_Col2_Pin|DI_Col1_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_INPUT;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);

  /*Configure GPIO pins : PB12 PB13 PB14 PB15 */
  GPIO_InitStruct.Pin = GPIO_PIN_12|GPIO_PIN_13|GPIO_PIN_14|GPIO_PIN_15;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);

}
